/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.web.connector.grizzly.async;

import com.sun.enterprise.web.connector.grizzly.AsyncExecutor;
import com.sun.enterprise.web.connector.grizzly.AsyncFilter;
import com.sun.enterprise.web.connector.grizzly.AsyncHandler;
import com.sun.enterprise.web.connector.grizzly.AsyncTask;
import com.sun.enterprise.web.connector.grizzly.ProcessorTask;
import com.sun.enterprise.web.connector.grizzly.Task;
import com.sun.enterprise.web.connector.grizzly.async.AsyncProcessorTask;
import java.util.ArrayList;
import java.util.concurrent.ConcurrentLinkedQueue;

public class DefaultAsyncHandler
implements AsyncHandler {
    private ConcurrentLinkedQueue<AsyncTask> asyncProcessors = new ConcurrentLinkedQueue();
    private ConcurrentLinkedQueue<AsyncTask> interrruptedQueue = new ConcurrentLinkedQueue();
    private ArrayList<AsyncFilter> asyncFilters = new ArrayList();
    private String asyncExecutorClassName = "com.sun.enterprise.web.connector.grizzly.async.DefaultAsyncExecutor";

    private AsyncTask newAsyncProcessorTask() {
        AsyncProcessorTask asyncTask = new AsyncProcessorTask();
        asyncTask.setAsyncExecutor(this.newAsyncExecutor(asyncTask));
        return asyncTask;
    }

    private AsyncExecutor newAsyncExecutor(AsyncTask asyncTask) {
        Class<?> className = null;
        AsyncExecutor asyncExecutor = null;
        try {
            className = Class.forName(this.asyncExecutorClassName);
            asyncExecutor = (AsyncExecutor)className.newInstance();
        }
        catch (ClassNotFoundException ex) {
            throw new RuntimeException(ex);
        }
        catch (InstantiationException ex) {
            throw new RuntimeException(ex);
        }
        catch (IllegalAccessException ex) {
            throw new RuntimeException(ex);
        }
        if (asyncExecutor != null) {
            asyncExecutor.setAsyncTask(asyncTask);
            asyncExecutor.setAsyncHandler(this);
            for (AsyncFilter l : this.asyncFilters) {
                asyncExecutor.addAsyncFilter(l);
            }
        }
        return asyncExecutor;
    }

    private AsyncTask getAsyncProcessorTask() {
        AsyncTask asyncTask = this.asyncProcessors.poll();
        if (asyncTask == null) {
            asyncTask = this.newAsyncProcessorTask();
        } else {
            asyncTask.recycle();
        }
        return asyncTask;
    }

    public void handle(Task task) {
        boolean wasInterrupted;
        AsyncTask apt = null;
        if (task.getType() == 2) {
            apt = this.getAsyncProcessorTask();
            apt.setProcessorTask((ProcessorTask)task);
            apt.setSelectorThread(task.getSelectorThread());
        }
        if (!(wasInterrupted = this.interrruptedQueue.remove(task)) && apt == null) {
            String errorMsg = "";
            if (task.getSelectionKey() != null) {
                errorMsg = "Connection " + task.getSelectionKey().channel() + " wasn't interrupted";
            }
            throw new IllegalStateException(errorMsg);
        }
        if (apt == null) {
            apt = (AsyncTask)task;
        }
        apt.execute();
    }

    public void returnTask(AsyncTask asyncTask) {
        this.asyncProcessors.offer(asyncTask);
    }

    public void addToInterruptedQueue(AsyncTask task) {
        this.interrruptedQueue.offer(task);
    }

    public void removeFromInterruptedQueue(AsyncTask task) {
        this.interrruptedQueue.remove(task);
    }

    public void setAsyncExecutorClassName(String asyncExecutorClassName) {
        this.asyncExecutorClassName = asyncExecutorClassName;
    }

    public String getAsyncExecutorClassName() {
        return this.asyncExecutorClassName;
    }

    public void addAsyncFilter(AsyncFilter asyncFilter) {
        this.asyncFilters.add(asyncFilter);
    }

    public boolean removeAsyncFilter(AsyncFilter asyncFilter) {
        return this.asyncFilters.remove(asyncFilter);
    }
}

