/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.security.impl.policy;

import com.sun.xml.ws.policy.AssertionSet;
import com.sun.xml.ws.policy.NestedPolicy;
import com.sun.xml.ws.policy.PolicyAssertion;
import com.sun.xml.ws.policy.sourcemodel.AssertionData;
import com.sun.xml.ws.security.impl.policy.AlgorithmSuite;
import com.sun.xml.ws.security.impl.policy.Constants;
import com.sun.xml.ws.security.impl.policy.Layout;
import com.sun.xml.ws.security.impl.policy.PolicyUtil;
import com.sun.xml.ws.security.impl.policy.Token;
import com.sun.xml.ws.security.policy.MessageLayout;
import com.sun.xml.ws.security.policy.SecurityAssertionValidator;
import com.sun.xml.ws.security.policy.SecurityPolicyVersion;
import java.util.Collection;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AsymmetricBinding
extends PolicyAssertion
implements com.sun.xml.ws.security.policy.AsymmetricBinding,
SecurityAssertionValidator {
    private SecurityAssertionValidator.AssertionFitness fitness = SecurityAssertionValidator.AssertionFitness.IS_VALID;
    private com.sun.xml.ws.security.policy.Token initiatorToken;
    private com.sun.xml.ws.security.policy.Token recipientToken;
    private com.sun.xml.ws.security.policy.Token initiatorSignatureToken;
    private com.sun.xml.ws.security.policy.Token recipientSignatureToken;
    private com.sun.xml.ws.security.policy.Token initiatorEncryptionToken;
    private com.sun.xml.ws.security.policy.Token recipientEncryptionToken;
    private com.sun.xml.ws.security.policy.AlgorithmSuite algSuite;
    private boolean includeTimestamp = false;
    private boolean disableTimestampSigning = false;
    private boolean contentOnly = true;
    private MessageLayout layout = MessageLayout.Lax;
    private String protectionOrder = "SignBeforeEncrypting";
    private boolean protectToken = false;
    private boolean protectSignature = false;
    private boolean populated = false;
    private SecurityPolicyVersion spVersion;

    public AsymmetricBinding() {
        this.spVersion = SecurityPolicyVersion.SECURITYPOLICY200507;
    }

    public AsymmetricBinding(AssertionData name, Collection<PolicyAssertion> nestedAssertions, AssertionSet nestedAlternative) {
        super(name, nestedAssertions, nestedAlternative);
        String nsUri = this.getName().getNamespaceURI();
        this.spVersion = PolicyUtil.getSecurityPolicyVersion(nsUri);
    }

    @Override
    public com.sun.xml.ws.security.policy.Token getRecipientToken() {
        this.populate();
        return this.recipientToken;
    }

    @Override
    public com.sun.xml.ws.security.policy.Token getInitiatorToken() {
        this.populate();
        return this.initiatorToken;
    }

    @Override
    public com.sun.xml.ws.security.policy.Token getRecipientSignatureToken() {
        this.populate();
        return this.recipientSignatureToken;
    }

    @Override
    public com.sun.xml.ws.security.policy.Token getInitiatorSignatureToken() {
        this.populate();
        return this.initiatorSignatureToken;
    }

    @Override
    public com.sun.xml.ws.security.policy.Token getRecipientEncryptionToken() {
        this.populate();
        return this.recipientEncryptionToken;
    }

    @Override
    public com.sun.xml.ws.security.policy.Token getInitiatorEncryptionToken() {
        this.populate();
        return this.initiatorEncryptionToken;
    }

    public void setAlgorithmSuite(com.sun.xml.ws.security.policy.AlgorithmSuite algSuite) {
        this.algSuite = algSuite;
    }

    @Override
    public com.sun.xml.ws.security.policy.AlgorithmSuite getAlgorithmSuite() {
        this.populate();
        if (this.algSuite == null) {
            this.algSuite = new AlgorithmSuite();
            Constants.logger.log(Level.FINE, "Using Default Algorithm Suite Basic128");
        }
        return this.algSuite;
    }

    public void includeTimeStamp(boolean value) {
        this.populate();
        this.includeTimestamp = value;
    }

    @Override
    public boolean isIncludeTimeStamp() {
        this.populate();
        return this.includeTimestamp;
    }

    @Override
    public boolean isDisableTimestampSigning() {
        this.populate();
        return this.disableTimestampSigning;
    }

    public void setLayout(MessageLayout layout) {
        this.layout = layout;
    }

    @Override
    public MessageLayout getLayout() {
        this.populate();
        return this.layout;
    }

    public void setInitiatorToken(com.sun.xml.ws.security.policy.Token token) {
        this.initiatorToken = token;
    }

    public void setRecipientToken(com.sun.xml.ws.security.policy.Token token) {
        this.recipientToken = token;
    }

    public void setInitiatorSignatureToken(com.sun.xml.ws.security.policy.Token token) {
        this.initiatorSignatureToken = token;
    }

    public void setRecipientSignatureToken(com.sun.xml.ws.security.policy.Token token) {
        this.recipientSignatureToken = token;
    }

    public void setInitiatorEncryptionToken(com.sun.xml.ws.security.policy.Token token) {
        this.initiatorEncryptionToken = token;
    }

    public void setRecipientEncryptionToken(com.sun.xml.ws.security.policy.Token token) {
        this.recipientEncryptionToken = token;
    }

    @Override
    public boolean isSignContent() {
        this.populate();
        return this.contentOnly;
    }

    public void setSignContent(boolean contentOnly) {
        this.contentOnly = contentOnly;
    }

    public void setProtectionOrder(String order) {
        this.protectionOrder = order;
    }

    @Override
    public String getProtectionOrder() {
        this.populate();
        return this.protectionOrder;
    }

    public void setTokenProtection(boolean value) {
        this.protectToken = value;
    }

    public void setSignatureProtection(boolean value) {
        this.protectSignature = value;
    }

    @Override
    public boolean getTokenProtection() {
        this.populate();
        return this.protectToken;
    }

    @Override
    public boolean getSignatureProtection() {
        this.populate();
        return this.protectSignature;
    }

    @Override
    public SecurityAssertionValidator.AssertionFitness validate(boolean isServer) {
        return this.populate(isServer);
    }

    private void populate() {
        this.populate(false);
    }

    private synchronized SecurityAssertionValidator.AssertionFitness populate(boolean isServer) {
        if (!this.populated) {
            NestedPolicy policy = this.getNestedPolicy();
            if (policy == null) {
                if (Constants.logger.isLoggable(Level.FINE)) {
                    Constants.logger.log(Level.FINE, "NestedPolicy is null");
                }
                this.populated = true;
                return this.fitness;
            }
            AssertionSet as = policy.getAssertionSet();
            for (PolicyAssertion assertion : as) {
                if (PolicyUtil.isInitiatorToken(assertion, this.spVersion)) {
                    this.initiatorToken = ((Token)assertion).getToken();
                    continue;
                }
                if (PolicyUtil.isRecipientToken(assertion, this.spVersion)) {
                    this.recipientToken = ((Token)assertion).getToken();
                    continue;
                }
                if (PolicyUtil.isRecipientSignatureToken(assertion, this.spVersion)) {
                    this.recipientSignatureToken = ((Token)assertion).getToken();
                    continue;
                }
                if (PolicyUtil.isRecipientEncryptionToken(assertion, this.spVersion)) {
                    this.recipientEncryptionToken = ((Token)assertion).getToken();
                    continue;
                }
                if (PolicyUtil.isInitiatorSignatureToken(assertion, this.spVersion)) {
                    this.initiatorSignatureToken = ((Token)assertion).getToken();
                    continue;
                }
                if (PolicyUtil.isInitiatorEncryptionToken(assertion, this.spVersion)) {
                    this.initiatorEncryptionToken = ((Token)assertion).getToken();
                    continue;
                }
                if (PolicyUtil.isAlgorithmAssertion(assertion, this.spVersion)) {
                    this.algSuite = (com.sun.xml.ws.security.policy.AlgorithmSuite)((Object)assertion);
                    continue;
                }
                if (PolicyUtil.isIncludeTimestamp(assertion, this.spVersion)) {
                    this.includeTimestamp = true;
                    continue;
                }
                if (PolicyUtil.isEncryptBeforeSign(assertion, this.spVersion)) {
                    this.protectionOrder = "EncryptBeforeSigning";
                    continue;
                }
                if (PolicyUtil.isSignBeforeEncrypt(assertion, this.spVersion)) {
                    this.protectionOrder = "SignBeforeEncrypting";
                    continue;
                }
                if (PolicyUtil.isContentOnlyAssertion(assertion, this.spVersion)) {
                    this.contentOnly = false;
                    continue;
                }
                if (PolicyUtil.isMessageLayout(assertion, this.spVersion)) {
                    this.layout = ((Layout)assertion).getMessageLayout();
                    continue;
                }
                if (PolicyUtil.isProtectTokens(assertion, this.spVersion)) {
                    this.protectToken = true;
                    continue;
                }
                if (PolicyUtil.isEncryptSignature(assertion, this.spVersion)) {
                    this.protectSignature = true;
                    continue;
                }
                if (PolicyUtil.disableTimestampSigning(assertion)) {
                    this.disableTimestampSigning = true;
                    continue;
                }
                if (assertion.isOptional()) continue;
                Constants.log_invalid_assertion(assertion, isServer, "AsymmetricBinding");
                this.fitness = SecurityAssertionValidator.AssertionFitness.HAS_UNKNOWN_ASSERTION;
            }
            this.populated = true;
        }
        return this.fitness;
    }

    @Override
    public SecurityPolicyVersion getSecurityPolicyVersion() {
        return this.spVersion;
    }
}

